#include "spaceship.h"

#include <debris.h>
#include <tgaloader.h>

Spaceship::Spaceship(Object *parent, bool *fire_cannon, bool *fire_grappling_hook, bool *accelerate, bool *decelerate, bool *turn_left, bool *turn_right, float engine_power) : Material(parent) {

	Debris *debris;
	Texture *t1 = new Texture(), *t2 = new Texture();				//done the long way because don't need to be made actual graphics textures
	LoadTGA(t1, "debris.tga");
	LoadTGA(t2, "debrism.tga");
	debris = new Debris(parent, this, t1, t2, 9, emptylevels, 0.3f);
	debris->setDrawOrder(99);
	this->parent = debris;

	main_cannon_dir = new MultiAtomDir();
	left_engine_dir = new AtomDir();
	right_engine_dir = new AtomDir();

	main_cannon = new DGun(this, fire_cannon, main_cannon_dir, 10.0f, 75.0f, 10, 50);
	left_engine = new DActuator(this, left_engine_dir);
	right_engine = new DActuator(this, right_engine_dir);
	this->engine_power = engine_power;

	grappling_hook = new GrapplingHook(this, fire_grappling_hook, main_cannon_dir, 20.0f);

	left_engine->assignAtomGroup(3);
	right_engine->assignAtomGroup(4);
	left_engine->assignAtomGroup(5);
	right_engine->assignAtomGroup(6);
	main_cannon->assignAtomGroup(7);
	main_cannon->assignAtomGroup(8);
	grappling_hook->assignAtomGroup(9);

	this->accelerate = accelerate;
	this->decelerate = decelerate;
	this->turn_left = turn_left;
	this->turn_right = turn_right;

	particle = new Texture("particle.tga");
}

void Spaceship::stepFunc() {
	Material::stepFunc();

	/*			//alternate control scheme
	if(*turn_right && !*turn_left) {
		left_engine->applyForce(engine_power * 0.5f);
		right_engine->applyForce(-engine_power * 0.5f);
	}
	else if(*turn_left && !*turn_right) {
		left_engine->applyForce(-engine_power * 0.5f);
		right_engine->applyForce(engine_power * 0.5f);
	}
	else if(*accelerate && !*decelerate) {
		left_engine->applyForce(engine_power);
		right_engine->applyForce(engine_power);
	}
	else if(*decelerate && !*accelerate) {
		left_engine->applyForce(-engine_power);
		right_engine->applyForce(-engine_power);
	}
	*/

	if((*accelerate && !*turn_left) || *turn_right) {
		left_engine->applyForce(engine_power);

		Atom *a = new Atom(left_engine_dir->x - left_engine_dir->dx * 10.0f, left_engine_dir->y - left_engine_dir->dy * 10.0f, 1.0f, left_engine_dir->ix - 3.0f * left_engine_dir->dx + rand() % 10 * 0.1f - 0.5f, left_engine_dir->iy - 3.0f * left_engine_dir->dy + rand() % 10 * 0.1f - 0.5f);
		a->level = 2;
		a->levels[1] = false;
		a->levels[2] = false;
		new Particle(this, a, particle, 30 + rand() % 20, 20);
	}
	if((*accelerate && !*turn_right) || *turn_left) {
		right_engine->applyForce(engine_power);

		Atom *a = new Atom(right_engine_dir->x - right_engine_dir->dx * 10.0f, right_engine_dir->y - right_engine_dir->dy * 10.0f, 1.0f, right_engine_dir->ix - 3.0f * right_engine_dir->dx + rand() % 10 * 0.1f - 0.5f, right_engine_dir->iy - 3.0f * right_engine_dir->dy + rand() % 10 * 0.1f - 0.5f);
		a->level = 2;
		a->levels[1] = false;
		a->levels[2] = false;
		new Particle(this, a, particle, 30 + rand() % 20, 20);
	}
}

void Spaceship::calculateCenter() {
	Atom *a;
	float div;
	int num = 0;
	cx = cy = 0;

	main_cannon_dir->front.begin();
	while(a = main_cannon_dir->front.get()) {
		cx += a->x;
		cy += a->y;
		num++;
	}

	div = 1.0f / num;
	cx *= div;
	cy *= div;
}

void Spaceship::addAtom(Atom *a) {
	Material::addAtom(a);

	if(a->group == 3) {
		left_engine_dir->front = a;
	}
	else if(a->group == 4) {
		right_engine_dir->front = a;
	}
	else if(a->group == 5) {
		left_engine_dir->back = a;
	}
	else if(a->group == 6) {
		right_engine_dir->back = a;
	}
	else if(a->group == 7) {
		main_cannon_dir->addFront(a);
	}
	else if(a->group == 8) {
		main_cannon_dir->addBack(a);
	}
	else if(a->group == 9) {
		grappling_hook->hook = a;
	}

}